/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.mutantmonsters.world.level.SeismicWave;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.init.v3.registry.LookupHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEventsHandler {
    public static EventResult onItemUseTick(class_1309 entity, class_1799 useItem, MutableInt useItemRemaining) {
        if (entity.method_6118(class_1304.field_6174).method_41406(ModItems.MUTANT_SKELETON_CHESTPLATE_ITEM) && useItem.method_7909() instanceof class_1753 && class_1753.method_7722((int)(useItem.method_7935(entity) - useItemRemaining.getAsInt())) < 1.0f) {
            useItemRemaining.mapInt(i -> i - 2);
        }
        return EventResult.PASS;
    }

    public static EventResult onArrowLoose(class_1657 player, class_1799 weapon, class_1937 level, MutableInt charge, boolean hasAmmo) {
        if (player.method_6118(class_1304.field_6169).method_41406(ModItems.MUTANT_SKELETON_SKULL_ITEM) && weapon.method_7909() instanceof class_1753) {
            class_6880 enchantment = LookupHelper.lookupEnchantment((class_4538)level, (class_5321)class_1893.field_9108);
            if (weapon.method_58657().method_57536(enchantment) == 0) {
                class_1799 itemStack = weapon.method_7972();
                itemStack.method_7978(enchantment, 1);
                itemStack.method_7930(level, (class_1309)player, player.method_6014());
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static void onEndPlayerTick(class_1657 player) {
        SeismicWave seismicWave;
        PlayerEventsHandler.playShoulderEntitySound(player, player.method_7356());
        PlayerEventsHandler.playShoulderEntitySound(player, player.method_7308());
        if (!player.method_37908().field_9236 && (seismicWave = SeismicWave.poll(player)) != null) {
            PlayerEventsHandler.handleSeismicWave(player, seismicWave);
        }
    }

    private static void handleSeismicWave(class_1657 player, @NotNull SeismicWave seismicWave) {
        seismicWave.affectBlocks(player.method_37908(), (class_1297)player);
        class_238 box = new class_238((double)seismicWave.method_10263(), (double)seismicWave.method_10264() + 1.0, (double)seismicWave.method_10260(), (double)seismicWave.method_10263() + 1.0, (double)seismicWave.method_10264() + 2.0, (double)seismicWave.method_10260() + 1.0);
        for (class_1309 livingEntity : player.method_37908().method_18467(class_1309.class, box)) {
            if (livingEntity == player || player.method_5854() == livingEntity) continue;
            livingEntity.method_5643(DamageSourcesHelper.source((class_4538)player.method_37908(), ModRegistry.PLAYER_SEISMIC_WAVE_DAMAGE_TYPE, (class_1297)player), (float)(6 + player.method_59922().method_43048(3)));
        }
    }

    private static void playShoulderEntitySound(class_1657 player, @Nullable class_2487 compoundNBT) {
        block3: {
            block2: {
                if (compoundNBT != null && !compoundNBT.method_10545("Silent")) break block2;
                if (compoundNBT.method_10577("Silent")) break block3;
            }
            class_1299.method_5898((String)compoundNBT.method_10558("id")).filter(((class_1299)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.comp_349())::equals).ifPresent(entityType -> {
                if (player.method_37908().field_9229.method_43048(500) == 0) {
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)ModSoundEvents.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.comp_349(), player.method_5634(), 1.0f, (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.2f + 1.5f);
                }
            });
        }
    }

    public static EventResult onItemToss(class_1657 player, class_1542 itemEntity) {
        if (!player.method_37908().field_9236) {
            boolean isHand;
            class_1799 itemStack = itemEntity.method_6983();
            boolean bl = isHand = itemStack.method_7909() == ModItems.ENDERSOUL_HAND_ITEM.comp_349() && itemStack.method_7986();
            if (itemStack.method_7909() == class_1802.field_8449 || isHand) {
                int endersoulFragments = 0;
                for (EndersoulFragment endersoulFragment : player.method_37908().method_18467(EndersoulFragment.class, player.method_5829().method_1014(8.0))) {
                    if (endersoulFragment.getOwner() != player) continue;
                    ++endersoulFragments;
                    endersoulFragment.method_31472();
                }
                if (endersoulFragments > 0) {
                    EntityUtil.sendParticlePacket((class_1297)player, (class_2394)ModRegistry.ENDERSOUL_PARTICLE_TYPE.comp_349(), 256);
                    int additionalDamageValue = endersoulFragments * 60;
                    if (isHand) {
                        int damageValue = itemStack.method_7919() - additionalDamageValue;
                        itemStack.method_7974(Math.max(damageValue, 0));
                    } else {
                        class_1799 newItemStack = new class_1799((class_1935)ModItems.ENDERSOUL_HAND_ITEM.comp_349());
                        newItemStack.method_7974(newItemStack.method_7936() - additionalDamageValue);
                        itemEntity.method_6979(newItemStack);
                    }
                }
            }
        }
        return EventResult.PASS;
    }
}

